/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.serviceaction;

import com.ibm.hwmca.fw.service.serviceaction.ServiceAction;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionException;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionFactory;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.p.pa.problem.PIProblem;
import com.ibm.hwmca.p.service.serviceaction.mesinstall.PIMesInstallEnclosure;
import com.ibm.hwmca.p.service.serviceaction.mesremove.PIMesRemoveEnclosure;
import com.ibm.hwmca.p.service.serviceaction.repair.PIAIXSAELRepair;
import com.ibm.hwmca.p.service.serviceaction.repair.PIInfoCenterRepair;
import com.ibm.hwmca.p.service.serviceaction.repair.PIRepair;
import com.ibm.hwmca.p.service.serviceaction.replace.PIReplaceEnclosure;
import com.ibm.hwmca.p.service.serviceaction.replace.PIReplaceFrus;
import com.ibm.hwmca.p.service.serviceaction.utils.PIPowerOffLocation;
import com.ibm.hwmca.p.service.serviceaction.utils.PIPowerOnLocation;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.util.Map;

public class PIServiceActionFactory
implements ServiceActionFactory {
    public ServiceAction create(ServiceActionType serviceType, Map inputContext) throws ServiceActionException {
        if (serviceType == ServiceActionType.REPAIR_PROBLEM) {
            PIProblem pip;
            String osType;
            CommonProblem cp = (CommonProblem)inputContext.get("SERVICEABLE_EVENT");
            if (cp instanceof PIProblem && (osType = (pip = (PIProblem)cp).getPartitionOSType()) != null && osType.trim().toUpperCase().equals("AIX") && (pip.getPlatformLogID() == null || pip.getPlatformLogID().equals("0"))) {
                return new PIAIXSAELRepair();
            }
            int numFrus = cp.getPartCount();
            if (numFrus > 0) {
                return new PIRepair();
            }
            return new PIInfoCenterRepair();
        }
        if (serviceType == ServiceActionType.REPLACE_FRU) {
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.REPLACE_ENCLOSURE) {
            return new PIReplaceEnclosure();
        }
        if (serviceType == ServiceActionType.MES_INSTALL_FRU) {
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.MES_INSTALL_ENCLOSURE) {
            return new PIMesInstallEnclosure();
        }
        if (serviceType == ServiceActionType.MES_REMOVE_FRU) {
            return new PIReplaceFrus();
        }
        if (serviceType == ServiceActionType.MES_REMOVE_ENCLOSURE) {
            return new PIMesRemoveEnclosure();
        }
        if (serviceType == ServiceActionType.POWER_OFF) {
            return new PIPowerOffLocation();
        }
        if (serviceType == ServiceActionType.POWER_ON) {
            return new PIPowerOnLocation();
        }
        throw new ServiceActionException("unsupported ServiceActionType for this impl:" + serviceType);
    }
}

